#!/bin/bash

#GET UPTIME
UPT=$(</proc/uptime)
IFS=". " read -a UPA <<< "${UPT}"
UPT="${UPA[0]}"
DEL='|S|'

#GET SYSTEM DETAILS
MOD=$(sed 's/\x0//g' /proc/device-tree/model)
TEM=$(/usr/bin/vcgencmd measure_temp)
TEM=${TEM:5:10}
IFS="." read -a TMA <<< "${TEM}"
TEM="${TMA[0]}";

#GET INTERFACE DETAILS
TST=$(ip addr show | awk '/inet.*brd/{print $NF; exit}')
NIN=${TST}
IIP=$(ip addr show "$NIN" | awk '/inet / {print $2}' | cut -d/ -f 1)

# SELECT MAC SOURCE:
if ip link show eth0 > /dev/null 2>&1; then
  MAC_IF="eth0"
elif ip link show wlan0 > /dev/null 2>&1; then
  MAC_IF="wlan0"
else
  MAC_IF=""
fi
if [[ -n "$MAC_IF" ]]; then
  MAC=$(ip link show "$MAC_IF" | awk '/ether/ {print $2}')
else
  MAC=""
fi

#GET WIFI DETAILS
if [[ $NIN == 'wlan0' ]]
then
  {
  SID=$(iwconfig wlan0 | grep 'ESSID:' | awk '{print $4}' | sed 's/ESSID://g' | sed 's/"//g')
  SIG=$(iwconfig wlan0 | grep 'Link Quality' | awk '{print $2}' | sed 's/ESSID://g' | sed 's/"//g')
  SIG=${SIG:8:10}
  IFS="/" read -a SGA <<< "${SIG}"
  SIG="${SGA[0]}";
  }
else
  {
  SID="Wired"
  SIG="100"
  }
fi

#OUTPUT
echo "${MOD}${DEL}${MAC}${DEL}${IIP}${DEL}${UPT}${DEL}${TEM}${DEL}${SID}${DEL}${SIG}"